<!DOCTYPE html>
<html lang="en-US" prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb#">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>DataTables Server-side Processing with PHP and MySQL</title>

	<link rel="canonical" href="https://www.phplift.net/" />
	<link rel="publisher" href="https://plus.google.com/104843303742341697879" />
	<meta property="og:locale" content="en_US" />
	<meta property="og:type" content="article" />
	<meta property="og:title" content="DataTables Server-side Processing with PHP and MySQL" />
	<meta property="og:description" content="PHPLift is a web programming blog focus on all web development tutorials specially PHP and MySQL, HTML, CSS, Ajax, Jquery, Web, Demos, JavaScript, Designing" />
	<meta property="og:site_name" content="PHPLift">
	<meta property="og:image" content="http://www.phplift.net/wp-content/uploads/2017/01/logo.png">
	<meta property="og:url" content="http://www.PHPLift.net/" />
	<meta property="og:site_name" content="DataTables Server-side Processing with PHP and MySQL" />
	<meta property="article:publisher" content="https://www.facebook.com/PHiPLift" />
	<meta property="article:published_time" content="2014-02-12T18:37:09+00:00" />
	<meta property="article:modified_time" content="2014-02-12T18:39:48+00:00" />

	<meta name="twitter:card" content="summary" />
	<meta name="twitter:site" content="@PHPLift" />
	<meta name="twitter:domain" content="DataTables Server-side Processing with PHP and MySQL" />
	<meta name="twitter:creator" content="@huzoorbux" />

	<meta content='PHPlift is a web programming blog focus on all web development tutorials specially PHP and MySQL, HTML, CSS, Ajax, Jquery, Web, Demos, JavaScript, Designing' name='description' />

	<link href="https://fonts.googleapis.com/css?family=Montserrat" rel='stylesheet' type='text/css'>
	<link href="https://unpkg.com/tailwindcss@^1.0/dist/tailwind.min.css" rel="stylesheet">

	<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
	<script>
		(adsbygoogle = window.adsbygoogle || []).push({
			google_ad_client: "ca-pub-6883622550208397",
			enable_page_level_ads: true
		});
	</script>
	<style>
		.PHPGangMessage a,
		.subbase a {
			color: blue;
		}
	</style>
</head>

<body>
	<header class="text-gray-700 body-font">
		<div class="container mx-auto flex flex-wrap p-5 flex-col md:flex-row items-center">
			<a href="https://www.phplift.net/" class="flex title-font font-medium items-center text-gray-900 mb-4 md:mb-0">
				<span class="ml-3 text-xl">PHPLift</span>
			</a>
			<nav class="md:ml-auto flex flex-wrap items-center text-base justify-center">
				<a href="https://feeds2.feedburner.com/PHPLift" title="PHPLift feed" class="mr-5 hover:text-gray-900"><img alt="feed" height="26" src="https://feeds2.feedburner.com/~fc/PHPLift1?bg=f2a0bb&amp;fg=000000&amp;anim=0&amp;label=Readers" style="border:0;margin-right:10px;margin-top:6px" width="88"></a>
				<a href="https://demos.phplift.net/" class="mr-5 hover:text-gray-900">Demos</a>
				<a href="https://www.phplift.net/category/php/" class="mr-5 hover:text-gray-900">PHP Tutorials</a>
				<a href="https://www.phplift.net/request/" class="mr-5 hover:text-gray-900">Request Tutorial</a>
				<a href="https://www.phplift.net/jobs/" class="mr-5 hover:text-gray-900">JOBS</a>
			</nav>
		</div>
	</header>

	<!-- DataTables CSS -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css" />

	<style>
		table.dataTable tr.odd {
			background-color: #ace0e0;
		}

		.sorting {
			text-align: left;
		}

		table.dataTable tr.even td.sorting_1 {
			background-color: #ffffff;
		}

		table.dataTable.hover tbody tr:hover,
		table.dataTable.display tbody tr:hover {
			background-color: #ace0e0;
		}

		td {
			text-transform: uppercase;
		}
	</style>


	<table id="table_list" class="dataTable" width="100%" cellspacing="0">
		<thead>
			<tr>
				<th>S.No.</th>
				<th>Country</th>
				<th>ISO Alpha-2 Code </th>
				<th>ISO Alpha-3 Code </th>
			</tr>
		</thead>

	</table>


	<!-- Jquery Core Js -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>


	<!-- DataTables -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js"></script>
	<script>
		$(document).ready(function(e) {
			$('#table_list').dataTable({
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "dataList.php",
					type: "POST",
					error: function(data) {
						alert("some error occured please try again.")

					}
				}
			});
		});
	</script>


	<footer class="text-gray-700 body-font">
		<div class="container px-5 py-24 mx-auto flex items-center sm:flex-row flex-col">
			<a href="http://www.huzoorbux.com/" class="flex title-font font-medium items-center md:justify-start justify-center text-gray-900">
				<span class="ml-3 text-xl">Huzoor Bux Production</span>
			</a>
			<p class="text-sm text-gray-500 sm:ml-4 sm:pl-4 sm:border-l-2 sm:border-gray-200 sm:py-2 sm:mt-0 mt-4">&copy; 2020 phplift.net</p>
			<span class="inline-flex sm:ml-auto sm:mt-0 mt-4 justify-center sm:justify-start">
				<a href="https://www.facebook.com/PHiPLift/" class="text-gray-500">
					<svg fill="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" class="w-5 h-5" viewBox="0 0 24 24">
						<path d="M18 2h-3a5 5 0 00-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 011-1h3z"></path>
					</svg>
				</a>
				<a href="https://twitter.com/PHPLift/" class="ml-3 text-gray-500">
					<svg fill="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" class="w-5 h-5" viewBox="0 0 24 24">
						<path d="M23 3a10.9 10.9 0 01-3.14 1.53 4.48 4.48 0 00-7.86 3v1A10.66 10.66 0 013 4s-4 9 5 13a11.64 11.64 0 01-7 2c9 5 20 0 20-11.5a4.5 4.5 0 00-.08-.83A7.72 7.72 0 0023 3z"></path>
					</svg>
				</a>
			</span>
		</div>
	</footer>



</body>

</html>