<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHP Contact Form with Google reCAPTCHA V3</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.1.1/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.1.0/css/all.css" integrity="sha384-lKuwvrZot6UHsBSfcMvOkWwlCMgc0TaWr+30HWe3a4ltaBwTZhyTEggF5tJv8tbt" crossorigin="anonymous">
</head>
<body>
    
<div class="container">
    <div class="row justify-content-center">
		<div class="col-12 col-md-8 col-lg-6 pb-5">


                    <!--Form with header-->

                    <form action="send.php" method="post" id="submitForm">
                        <div class="card border-primary rounded-0">
                            <div class="card-header p-0">
                                <div class="bg-info text-white text-center py-2">
                                    <h3><i class="fa fa-envelope"></i> Contact Form</h3>
                                    <p class="m-0">Google reCaptcha Example</p>
                                </div>
                            </div>
                            <div class="card-body p-3">

                                <!--Body-->
                                <div class="form-group">
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="fa fa-user text-info"></i></div>
                                        </div>
                                        <input type="text" class="form-control" id="name" name="name" placeholder="Name" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="fa fa-envelope text-info"></i></div>
                                        </div>
                                        <input type="email" class="form-control" id="email" name="email" placeholder="Email" required>
                                    </div>
                                </div>

                                <div class="text-center">
                                <button data-sitekey="Your_reCaptcha_Public_Key" data-callback="onSubmit" data-action="submit"  class="g-recaptcha btn btn-info btn-block rounded-0 py-2">Send</button>	
                                    
                                </div>
                                <div id="message"></div>
                            </div>

                        </div>
                    </form>
                    <!--Form with header-->


                </div>
	</div>
</div>

<!-- jQuery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<!-- captcha -->
<script src="https://www.google.com/recaptcha/api.js"></script>

<script>
    function onSubmit(token) {
        var formData = $("#submitForm").serialize();
        $(".has-error").removeClass("has-error");
        if ($("#name").val() == "")
        {
            $("#message").html("Enter Name.");
            return false;
        }
        if ($("#email").val() == "")
        {
            $("#message").html("Enter Email.");
            return false;
        }
        $.ajax({
            url: "send.php",
            type: "POST",
            data: formData,
            success: function (data) {
                $("#submitForm")[0].reset();
                // console.log(data)
                $("#message").html(data)
            },
            error: function() {
                alert("error handling here");
            }
        });
    }
</script>
</body>
</html>